<?php
$default_settings = [
    'email_value' => '',
    'button_value' => '',
    'button_bg_color' => '',
    'button_bg_color_gradient' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$html_id = ct_get_element_id($settings);
if(class_exists('MC4WP_Container')) : ?>
    <div id="<?php echo esc_attr($html_id); ?>" class="ct-mailchimp ct-mailchimp1 <?php echo esc_attr($settings['style']); ?>">
    	<?php if(!empty($email_value)) : ?>
    		<div id="mailchimp-email" class="mailchimp-email" data-email-value="<?php echo esc_attr($email_value); ?>"></div>
    	<?php endif; ?>
    	<?php if(!empty($button_value)) : ?>
    		<div id="mailchimp-button" class="mailchimp-button" data-button-value="<?php echo esc_attr($button_value); ?>"></div>
    	<?php endif; ?>
        <div class="ct-inline-css"  data-css="
            <?php if( !empty($button_bg_color) && !empty($button_bg_color_gradient) ) : ?>
                #<?php echo esc_attr($html_id) ?>.ct-mailchimp1.style3 .mc4wp-form [type='submit'] {
                    background-image: -webkit-linear-gradient(90deg, <?php echo esc_attr($button_bg_color); ?> 0%, <?php echo esc_attr($button_bg_color_gradient); ?> 50%, <?php echo esc_attr($button_bg_color); ?>);
                    background-image: -moz-linear-gradient(90deg, <?php echo esc_attr($button_bg_color); ?> 0%, <?php echo esc_attr($button_bg_color_gradient); ?> 50%, <?php echo esc_attr($button_bg_color); ?>);
                    background-image: -ms-linear-gradient(90deg, <?php echo esc_attr($button_bg_color); ?> 0%, <?php echo esc_attr($button_bg_color_gradient); ?> 50%, <?php echo esc_attr($button_bg_color); ?>);
                    background-image: -o-linear-gradient(90deg, <?php echo esc_attr($button_bg_color); ?> 0%, <?php echo esc_attr($button_bg_color_gradient); ?> 50%, <?php echo esc_attr($button_bg_color); ?>);
                    background-image: linear-gradient(90deg, <?php echo esc_attr($button_bg_color); ?> 0%, <?php echo esc_attr($button_bg_color_gradient); ?> 50%, <?php echo esc_attr($button_bg_color); ?>);
                    filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($button_bg_color); ?>', endColorStr='<?php echo esc_attr($button_bg_color_gradient); ?>');
                    background-color: transparent !important;
                }
            <?php endif; ?>">
        </div>
	    <?php echo do_shortcode('[mc4wp_form]'); ?>
    </div>
<?php endif; ?>
